const videoTitleModal = document.getElementById('videoTitleModal');
const video = document.getElementById('video');
const steps = Array.from(document.getElementsByClassName('step'));
const modal = document.getElementById('videoModal');
const modalVideo = document.getElementById('modalVideo');

const changeVideo = e => {
    e.preventDefault();
    const screenWidth = window.innerWidth;

    const step = e.currentTarget;
    const stepDescription = step.children[1].children[0].textContent;
    const videoIndex = step.getAttribute('data-video');

    // Se a tela for grande, muda o vídeo diretamente
    if (screenWidth >= 1081) {
        steps.forEach(element => element.classList.remove('active'));
        video.setAttribute('src', `./videos/${videoIndex}.mp4`);
        video.play();
        videoTitle.textContent = stepDescription;
        step.classList.add('active')
        return;
    }

    // Para telas pequenas, continua com a lógica do modal
    steps.forEach(element => element.classList.remove('active'));
    modalVideo.setAttribute('autoplay', '');
    modalVideo.setAttribute('src', `./videos/${videoIndex}.mp4`);
    videoTitleModal.textContent = stepDescription;
    step.classList.add('active');
    modal.style.display = "block";
};


// Adicionando um listener para fechar a modal ao clicar fora do vídeo
modal.addEventListener('click', () => {
    modal.style.display = "none"; // Fecha a modal
    modalVideo.pause(); // Pausa o vídeo
    modalVideo.setAttribute('src', ''); // Limpa o src para evitar carregar o vídeo em segundo plano
});

// Seleciona os botões de dark mode
const darkModeButtons = [document.getElementById('darkModeToggle')];
const body = document.body;
const header = document.querySelector('header');
const steps_ = document.querySelectorAll('.step');
const buttons = document.querySelectorAll('.button-header');
const headerLogo = document.getElementById('headerLogo');
const logoFooter = document.getElementById('logoFooter');
const locationDiv = document.getElementById('location');
const logoDiv = document.getElementById('logoDiv');

darkModeButtons.forEach(button => {
    button.addEventListener('click', () => {
        body.classList.toggle('dark-mode');
        header.classList.toggle('dark-mode');
        button.classList.toggle('dark-mode');
        document.querySelector('.playingVideo').classList.toggle('dark-mode');
        document.querySelector('footer').classList.toggle('dark-mode');
        document.querySelector('.bottom-nav').classList.toggle('dark-mode');
        locationDiv.classList.toggle('dark-mode');
        logoDiv.classList.toggle('dark-mode');
        

        // Troca as imagens de acordo com o modo
        if (body.classList.contains('dark-mode')) {
            headerLogo.src = './assets/imgs/unifan_logo_white.png';
            logoFooter.src = './assets/imgs/unifan_logo_white.png';
        } else {
            headerLogo.src = './assets/imgs/unifan_logo.png';
            logoFooter.src = './assets/imgs/unifan_logo_black.png';
        }

        // Adiciona/remova a classe do modo escuro em cada passo
        steps_.forEach(step => {
            step.classList.toggle('dark-mode');
        });

        // Adiciona/remova a classe do modo escuro em cada botão
        buttons.forEach(button => {
            button.classList.toggle('dark-mode');
        });

        // Troca o ícone do modo
        const modeIcon = button.querySelector('span');
        if (body.classList.contains('dark-mode')) {
            modeIcon.textContent = 'light_mode';
        } else {
            modeIcon.textContent = 'nightlight';
        }
    });

});

modalVideo.addEventListener('click', (e) => {
    e.stopPropagation(); // Impede que o clique no vídeo feche a modal
});


function openModal(event) {
    const videoId = event.currentTarget.getAttribute('data-video');
    const modal = document.getElementById('videoModal');
    const modalVideo = document.getElementById('modalVideo');
    const videoSource = `./videos/${videoId}.mp4`; // Supondo que os vídeos estão nomeados corretamente
    modalVideo.src = videoSource;
    modal.style.display = "block";
};

document.getElementById('closeModal').onclick = function () {
    const modal = document.getElementById('videoModal');
    modal.style.display = "none";
    const modalVideo = document.getElementById('modalVideo');
    modalVideo.pause();
    modalVideo.src = ""; // Limpa a fonte para parar o vídeo
};

// Fecha a modal se clicar fora dela
window.onclick = function (event) {
    const modal = document.getElementById('videoModal');
    if (event.target === modal) {
        modal.style.display = "none";
        const modalVideo = document.getElementById('modalVideo');
        modalVideo.pause();
        modalVideo.src = ""; // Limpa a fonte para parar o vídeo
    }
};